<?php
/**
 * @author QuanticaLabs - http://codecanyon.net/user/QuanticaLabs/portfolio?ref=QuanticaLabs
 *
 * @link			http://codecanyon.net/item/timetable-responsive-schedule-for-joomla/9749539?ref=QuanticaLabs
 * @copyright		Copyright (C) 2008 - 2014 quanticalabs.com . All rights reserved.
 * @license			GNU General Public License version 2 or later; see LICENSE under Licensing/ directory
 */
 
defined('_JEXEC') or die('Restricted access');
 
// import Joomla view library
jimport('joomla.application.component.view');
 
class TimetableViewTimetable extends JViewLegacy
{
	protected $events;
	protected $columns;
	protected $event_categories;
	protected $hour_categories;
	protected $google_fonts_html;
	
	
	function display($tpl = null) 
	{
		require_once JPATH_COMPONENT . '/helpers/timetable.php';
		TimetableHelper::addSubmenu('timetable');
		
		// load data
		$this->events = $this->loadEvents();
		$this->columns = $this->loadColumns();
		$this->event_categories = $this->loadEventCategories();
		$this->hour_categories = $this->loadHourCategories();
		$this->google_fonts_html = $this->loadGoogleFonts();
	
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode('<br />', $errors));

			return false;
		}
		
		$this->sidebar = JHtmlSidebar::render();
		$this->setDocument();
		parent::display($tpl);
	}
	
	protected function setDocument() 
	{		
		
		JToolbarHelper::title(JText::_('COM_TIMETABLE_SHORTCODE_GENERATOR'), 'columns');
		
		$document = JFactory::getDocument();
		$document->setTitle(JText::_('COM_TIMETABLE_SHORTCODE_GENERATOR'));
		$document->addStylesheet(COM_TIMETABLE_STYLES_URL . "style.css");
		$document->addStylesheet(COM_TIMETABLE_STYLES_URL . "colorpicker.css");
		JHtml::_('jquery.framework');
		$document->addScript("//ajax.googleapis.com/ajax/libs/jqueryui/1.10.4/jquery-ui.min.js");
			
		$document->addScript(COM_TIMETABLE_SCRIPTS_URL . "ZeroClipboard.min.js");
		$document->addScript(COM_TIMETABLE_SCRIPTS_URL . "colorpicker.js");
		$document->addScript(COM_TIMETABLE_SCRIPTS_URL . "timetable_admin.js");
		$document->addScriptDeclaration('
			config = {};
			config.admin_url = "' . COM_TIMETABLE_ADMIN_URL . '";
			config.img_url = "' . COM_TIMETABLE_IMAGES_URL . '";
			config.js_url = "' . COM_TIMETABLE_SCRIPTS_URL . '";
		');
		
	}
	
	protected function loadEvents() {		
		$db = JFactory::getDbo();
		$query = "SELECT id, title, alias
			FROM
				#__timetable_events";
		$db->setQuery($query);
		return $db->loadObjectList();
	}
	
	protected function loadEventCategories() {		
		$db = JFactory::getDbo();
		$query = "SELECT id, title, alias
			FROM
				#__timetable_categories";
		$db->setQuery($query);
		return $db->loadObjectList();
	}
	
	protected function loadHourCategories() {		
		$db = JFactory::getDbo();
		$query = "SELECT DISTINCT category
			FROM
				#__timetable_event_hours";
		$db->setQuery($query);
		return $db->loadObjectList();
	}
	
	protected function loadColumns() {		
		$db = JFactory::getDbo();
		$query = "SELECT id, title, alias
			FROM
				#__timetable_columns";
		$db->setQuery($query);
		return $db->loadObjectList();
	}
	
	protected function loadGoogleFonts() {		
		$fontsArray = TimetableUtils::getGoogleFonts();		
		$fontsHtml = "";
		$fontsCount = count($fontsArray->items);
		for($i=0; $i<$fontsCount; $i++)
		{
			$variantsCount = count($fontsArray->items[$i]->variants);
			if($variantsCount>1)
			{
				for($j=0; $j<$variantsCount; $j++)
				{
					$fontsHtml .= '<option value="' . $fontsArray->items[$i]->family . ":" . $fontsArray->items[$i]->variants[$j] . '">' . $fontsArray->items[$i]->family . ":" . $fontsArray->items[$i]->variants[$j] . '</option>';
				}
			}
			else
			{
				$fontsHtml .= '<option value="' . $fontsArray->items[$i]->family . '">' . $fontsArray->items[$i]->family . '</option>';
			}
		}
		return $fontsHtml;
	}
	
}